' XU1 battery drill charger model XCD-120 timer
' Automatically detects battery and charges 1 - 4 hours

' Version 1.1  16/2/05
' Clive Allan

' NOTE
' The sertxd command (directly after readadc) is included so that you can
' see the relative state of the battery and fine-tune the threshold values
' (used to determine the charge periods) to suit your pack.

' Symbols - flag variables

symbol timer_active = b0	'defines timer status, 1=active, 0=inactive
symbol hours_set = b1		'holds hours set 1-4, 0-time finished
symbol bat_in	=b2		'0, no battery installed, 1 batt installed
symbol bat_cd	=b3		'load acd resluts into reg
symbol flash	=b4
symbol flashrepeat=b5		'holds time flash rate
symbol convmin	=b6
symbol timer_count =b7
	
' Symbols output ports

symbol pwr_led = 4		'controls existing grn power led
symbol charge = 2		'triggers MOSFET charge active


' Symbols - input ports

symbol sense = pin1		'defines volt sense ACD input

' Initialise program variables

init:
  let dirs = %00000101		'charge set as output
  let pins = %00000000		'set all outputs to zero
  let timer_active = 0		'set timet status inactive
  let hours_set = 0 		'set hours to finished
  let bat_in = 0		'no battery

' Main program starts here

chrg1:
  high pwr_led			'turn on power led
  high charge	
  gosub	pow_chk	'check if batt installed
  if bat_in = 0 then chrg1	'wait for batt to be installed
  gosub timer

finish:
  high charge
  low pwr_led
  gosub pow_chk
  low charge
  if bat_in = 0 then chrg1	'bat removed after charging reset charger
  high pwr_led
  pause 5000
  goto finish

' Check if battery has been plugged

pow_chk:
  pause 100
  readadc 1,b3			'read sense voltage
  if b3 < 210 then bat_yes
  let bat_in = 0		'bat not installed
batret:
  return
bat_yes:
  let bat_in = 1		'bat installed
  goto batret

' Check voltage on battery, apply either 1, 2 or 4 hour charge

timer:
  high charge			'turn on charge temp to determine bat voltage
  pause 1000			'let it settle
  readadc 1,b3			'read sense voltage
  sertxd ("the battery voltage is ",#b3,cr,lf)
  if b3 < 180 then time4
  if b3 < 185 then time3
  if b3 < 190 then time2
  let hours_set = 2
  goto timerstart
time4:
  let hours_set = 5
  goto timerstart
time3:
  let hours_set = 4
  goto timerstart 	
time2:
  let hours_set = 3
	 
timerstart:
  for flashrepeat = 1 to 3	'flash number of hours to be charged to user
  for flash = 1 to hours_set
  low pwr_led
  pause 500
  high pwr_led
  pause 500
  next flash
  pause 3000 
  next flashrepeat
  high pwr_led

' Operator advised of charge time - go into timer mode	

  high charge
  hours_set = hours_set -1
  let convmin = hours_set*60
  for timer_count = 1 to convmin
  gosub pow_chk
  if bat_in = 0 then stoptimer
  pause 15000
  gosub pow_chk
  if bat_in = 0 then stoptimer
  pause 15000
  gosub pow_chk
  if bat_in = 0 then stoptimer
  pause 15000
  gosub pow_chk
  if bat_in = 0 then stoptimer
  pause 15000
  gosub pow_chk
  if bat_in = 0 then stoptimer		
  next timer_count
stoptimer:
  low charge	
  let timer_active = 0
  return
